       IDENTIFICATION DIVISION.
      *
      * Relativity Modernization Workbench Reference Implementation COBOL/CICS/VSAM Application
      *
      * Author: Nic Walsh February 2002
      *
      * This program processes orders - allows orders to be entered and
      * validates each stage of the order.
      *
       PROGRAM-ID.  ORDRERR1.
      *
       ENVIRONMENT DIVISION.
      *
       DATA DIVISION.
      *
       WORKING-STORAGE SECTION.
      *
       01  SWITCHES.
      *
           05  VALID-DATA-SW                   PIC X   VALUE 'Y'.
               88  VALID-DATA                          VALUE 'Y'.
           05  CUSTOMER-FOUND-SW               PIC X   VALUE 'Y'.
               88  CUSTOMER-FOUND                      VALUE 'Y'.
           05  PRODUCT-FOUND-SW                PIC X   VALUE 'Y'.
               88  PRODUCT-FOUND                       VALUE 'Y'.
           05  VALID-QUANTITY-SW               PIC X   VALUE 'Y'.
               88  VALID-QUANTITY                      VALUE 'Y'.
           05  VALID-NET-SW                    PIC X   VALUE 'Y'.
               88  VALID-NET                           VALUE 'Y'.
           05  VALID-CHECK-DIGIT-SW            PIC X   VALUE 'Y'.
               88  VALID-CHECK-DIGIT                   VALUE 'Y'.
      *
       01  FLAGS.
      *
           05  SEND-FLAG                       PIC X.
               88  SEND-ERASE                          VALUE '1'.
               88  SEND-DATAONLY                       VALUE '2'.
               88  SEND-DATAONLY-ALARM                 VALUE '3'.
           05  ATTRIBUTE-SET-FLAG              PIC X.
               88  SET-ATTRIBUTES                      VALUE '1'.
               88  RESET-ATTRIBUTES                    VALUE '2'.
      *
       01 PROD-CD-FLDS.
      *
           05 NMBR PIC 9 OCCURS 9.
           05 CHK-DIG PIC 9.
      *
       01 PROD-CD-FLDSX2.
      *
           05 NMBRX2 PIC 99 OCCURS 9.
           05 CHK-DIGX2 PIC 9.
      *
       01  X2B REDEFINES PROD-CD-FLDSX2.
      *
           05 NUMX2B OCCURS 9.
               10 DIGITA PIC 9.
               10 DIGITB PIC 9.

           05 CHK-DIGX2 PIC 9.
      *
       01 PROD-CD-FLDSX3.
      *
           05 NUMX3 PIC 9 OCCURS 9.
           05 CHECK-DIGITX3                    PIC 9.
      *
       01  CDSUM.
      *
           10 CDNUM PIC 9 OCCURS 9.
           10 CDCHECK-DIGIT                    PIC 9.
           10 CDACTUAL                         PIC 9.
      *
       01  CDREPS.
      *
           05 CDREP PIC 9 OCCURS 9.
           05 CDTOTAL                          PIC 9999.
           05 CDTOTAL-R  REDEFINES CDTOTAL.
               10  FILLER                      PIC 999.
               10  CDTOTAL-LAST                PIC 9.

           05 REPCHECK-DIGIT                   PIC 9.
      *
       01  WORK-FIELDS.
      *
           05  ITEM-SUB            PIC S9(3)   COMP-3  VALUE ZERO.
           05  LINE-ITEM-COUNT     PIC S9(3)   COMP-3  VALUE ZERO.
           05  NET-NUMERIC         PIC 9(7)V99.
           05  QTY-NUMERIC         PIC 9(5).
      *
       01  RESPONSE-CODE           PIC S9(8)   COMP.
      *
       01  COMMUNICATION-AREA.
      *
           05  CA-CONTEXT-FLAG               PIC X.
               88  PROCESS-ENTRY                       VALUE '1'.
               88  PROCESS-VERIFY                      VALUE '2'.
           05  CA-TOTAL-ORDERS               PIC S9(3) COMP-3.
           05  CA-INVOICE-RECORD             PIC X(318).
           05  CA-FIELDS-ENTERED.
               10  CA-PO-ENTERED-SW          PIC X.
                   88  CA-PO-ENTERED                VALUE 'Y'.
               10 CA-LINE-ITEM OCCURS 10.
                   15  CA-PCODE-ENTERED-SW   PIC X.
                       88  CA-PCODE-ENTERED         VALUE 'Y'.
                   15  CA-QTY-ENTERED-SW     PIC X.
                       88  CA-QTY-ENTERED           VALUE 'Y'.
                   15  CA-NET-ENTERED-SW     PIC X.
                       88  CA-NET-ENTERED           VALUE 'Y'.
      *
       01  TOTAL-LINE.
      *
           05  TL-TOTAL-ORDERS   PIC ZZ9.
           05  FILLER            PIC X(20) VALUE ' Orders entered.  Pr'.
           05  FILLER            PIC X(20) VALUE 'ess Enter to continu'.
           05  FILLER            PIC X(2)  VALUE 'e.'.
       COPY INVOICE.
      *
       COPY CUSTMAS.
      *
       COPY PRODUCT.
      *
       COPY INVCTL.
      *
       COPY ORDSET1X.
      *
       COPY DFHAID.
      *
       COPY ATTR.
      *
       COPY ERRPARM.
      *
       LINKAGE SECTION.
      *
       01  DFHCOMMAREA             PIC X(352).
      *
       01  COMMON-WORK-AREA.
      *
           05  CWA-DATE            PIC X(6).
           05  CWA-COMPANY-NAME    PIC X(40).
      *
       PROCEDURE DIVISION.

      *
       0000-ENTER-ORDERS.
      *
           MOVE DFHCOMMAREA TO COMMUNICATION-AREA.
           IF EIBCALEN = ZERO THEN
           EVALUATE TRUE

               WHEN EIBCALEN = ZERO
                   MOVE LOW-VALUE TO ORDMAP1
                   MOVE LOW-VALUE TO COMMUNICATION-AREA
                   MOVE ZERO      TO CA-TOTAL-ORDERS
                   MOVE 'Type order details.  Then press Enter.'
                       TO ORD-D-INSTR
                   MOVE 'F3=Exit   F12=Cancel' TO ORD-D-FKEY
                   MOVE -1 TO ORD-L-CUSTNO
                   SET SEND-ERASE TO TRUE
                   GO TO 1100_RECEIVE_ORDER_MAP
                   PERFORM 1400-SEND-ORDER-MAP
                   SET PROCESS-ENTRY TO TRUE

               WHEN EIBAID = DFHCLEAR
                   MOVE LOW-VALUE TO ORDMAP1
                   MOVE LOW-VALUE TO CA-INVOICE-RECORD
                                     CA-FIELDS-ENTERED
                   MOVE 'Type order details.  Then press Enter.'
                       TO ORD-D-INSTR
                   MOVE 'F3=Exit   F12=Cancel' TO ORD-D-FKEY
                   MOVE -1 TO ORD-L-CUSTNO
                   SET SEND-ERASE TO TRUE
                   GO TO 1100-RECEIVE-ORDER-MAP
                   PERFORM 1400-SEND-ORDER-MAP
                   SET PROCESS-ENTRY TO TRUE.

               WHEN EIBAID = DFHPA1 OR DFHPA2 OR DFHPA3
                   CONTINUE

               WHEN EIBAID = DFHPF3
                   PERFORM 3000-SEND-TOTAL-LINE
                   EXEC CICS
                       RETURN TRANSID('MENU')
                   END-EXEC

               WHEN EIBAID = DFHPF12
                   IF PROCESS-ENTRY
                       EXEC CICS
                           XCTL PROGRAM('INVMENU')
                       END-EXEC
                   ELSE
                      IF PROCESS-VERIFY THEN
                          MOVE LOW-VALUE TO ORDMAP1
                          MOVE LOW-VALUE TO CA-INVOICE-RECORD
                                            CA-FIELDS-ENTERED
                          MOVE 'Type order details.  Then press Enter.'
                               TO ORD-D-INSTR
                          MOVE 'F3=Exit   F12=Cancel' TO ORD-D-FKEY
                          MOVE -1 TO ORD-L-CUSTNO
                          SET SEND-ERASE TO TRUE
                          PERFORM 1400-SEND-ORDER-MAP
                          SET PROCESS-ENTRY TO TRUE
                       END-IF
                   END-IF

               WHEN EIBAID = DFHENTER
                   IF PROCESS-ENTRY
                       PERFORM 1000-PROCESS-ORDER-MAP
                   ELSE
                      IF PROCESS-VERIFY
                         PERFORM 2000-PROCESS-POST-ORDER
                         SET PROCESS-ENTRY TO TRUE
                      END-IF
                   END-IF

               WHEN EIBAID = DFHPF4
                   IF PROCESS-ENTRY
                       MOVE LOW-VALUE TO ORDMAP1
                       MOVE 'Invalid key pressed.' TO ORD-D-MESSAGE
                       MOVE -1 TO ORD-L-CUSTNO
                       SET SEND-DATAONLY-ALARM TO TRUE
                       PERFORM 1400-SEND-ORDER-MAP
                   ELSE
                      IF PROCESS-VERIFY
                         MOVE LOW-VALUE TO ORDMAP1
                         MOVE 'Type corrections.  Then press Enter.'
                             TO ORD-D-INSTR
                         MOVE 'F3=Exit   F12=Cancel' TO ORD-D-FKEY
                         MOVE -1 TO ORD-L-CUSTNO
                         SET RESET-ATTRIBUTES TO TRUE
                         SET SEND-DATAONLY TO TRUE
                         PERFORM 1400-SEND-ORDER-MAP
                         SET PROCESS-ENTRY TO TRUE
                      END-IF
                   END-IF

               WHEN OTHER
                   MOVE LOW-VALUE TO ORDMAP1
                   MOVE 'Invalid key pressed.' TO ORD-D-MESSAGE
                   MOVE -1 TO ORD-L-CUSTNO
                   SET SEND-DATAONLY-ALARM TO TRUE
                   PERFORM 1400-SEND-ORDER-MAP

           END-EVALUATE
           END-IF.

           EXEC CICS
               RETURN TRANSID('ORD1')
                      COMMAREA(COMMUNICATION-AREA)
           END-EXEC.
      *
       1000-PROCESS-ORDER-MAP.
      *
           PERFORM 1100-RECEIVE-ORDER-MAP.
           PERFORM 1200-EDIT-ORDER-DATA
           IF VALID-DATA
               PERFORM 1300-FORMAT-INVOICE-RECORD
               MOVE 'Press Enter to post this order.  Or press F4 to ent
      -             'er corrections.' TO ORD-D-INSTR
               MOVE 'F3=Exit   F4=Change   F12=Cancel' TO ORD-D-FKEY
               MOVE SPACE TO ORD-D-MESSAGE
               SET SEND-DATAONLY TO TRUE
               SET SET-ATTRIBUTES TO TRUE
               PERFORM 1400-SEND-ORDER-MAP
               SET PROCESS-VERIFY TO TRUE
           ELSE
               MOVE 'Type corrections.  Then press Enter.'
                   TO ORD-D-INSTR
               MOVE 'F3=Exit   F12=Cancel' TO ORD-D-FKEY
               SET SEND-DATAONLY-ALARM TO TRUE
               PERFORM 1400-SEND-ORDER-MAP.
      *
       1100-RECEIVE-ORDER-MAP.
      *
           EXEC CICS
               RECEIVE MAP('ORDMAP1')
                       MAPSET('ORDSET1')
                       INTO(ORDMAP1)
           END-EXEC.
           INSPECT ORDMAP1
                REPLACING ALL '_' BY SPACE.
      *
       1200-EDIT-ORDER-DATA.
      *
           MOVE ATTR-NO-HIGHLIGHT TO ORD-H-CUSTNO
                                     ORD-H-PO.
           MOVE ZERO TO LINE-ITEM-COUNT
                        INV-INVOICE-TOTAL.
           PERFORM 1220-EDIT-LINE-ITEM
               VARYING ITEM-SUB FROM 10 BY -1
                 UNTIL ITEM-SUB < 1.
           MOVE INV-INVOICE-TOTAL TO ORD-D-TOTAL.
           IF        LINE-ITEM-COUNT = ZERO
                 AND VALID-DATA
               MOVE ATTR-REVERSE TO ORD-H-PCODE(1)
               MOVE -1 TO ORD-L-PCODE(1)
               MOVE 'You must enter at least one line item'
                   TO ORD-D-MESSAGE
               MOVE 'N' TO VALID-DATA-SW.

           IF        ORD-L-PO = ZERO
                  OR ORD-D-PO = SPACE
               MOVE 'N' TO CA-PO-ENTERED-SW
           ELSE
               MOVE 'Y' TO CA-PO-ENTERED-SW.

           IF       ORD-L-CUSTNO = ZERO
                 OR ORD-D-CUSTNO = SPACE
               MOVE ATTR-REVERSE TO ORD-H-CUSTNO
               MOVE -1 TO ORD-L-CUSTNO
               MOVE 'You must enter a customer number'
                   TO ORD-D-MESSAGE
               MOVE 'N' TO VALID-DATA-SW
           ELSE
               PERFORM 1210-READ-CUSTOMER-RECORD
               IF CUSTOMER-FOUND
                   MOVE CM-LAST-NAME  TO ORD-D-LNAME
                   MOVE CM-FIRST-NAME TO ORD-D-FNAME
                   MOVE CM-ADDRESS    TO ORD-D-ADDR
                   MOVE CM-CITY       TO ORD-D-CITY
                   MOVE CM-STATE      TO ORD-D-STATE
                   MOVE CM-ZIP-CODE   TO ORD-D-ZIPCODE
               ELSE
                   MOVE SPACE TO ORD-D-LNAME
                                 ORD-D-FNAME
                                 ORD-D-ADDR
                                 ORD-D-CITY
                                 ORD-D-STATE
                                 ORD-D-ZIPCODE
                   MOVE ATTR-REVERSE TO ORD-H-CUSTNO
                   MOVE -1 TO ORD-L-CUSTNO
                   MOVE 'That customer does not exist'
                       TO ORD-D-MESSAGE
                   MOVE 'N' TO VALID-DATA-SW.
           IF VALID-DATA
               MOVE -1 TO ORD-L-CUSTNO.
      *
       1210-READ-CUSTOMER-RECORD.
      *
           EXEC CICS
               READ DATASET('CUSTMAS')
                    INTO(CUSTOMER-MASTER-RECORD)
                    RIDFLD(ORD-D-CUSTNO)
                    RESP(RESPONSE-CODE)
           END-EXEC.
           IF RESPONSE-CODE = DFHRESP(NORMAL)
               MOVE 'Y' TO CUSTOMER-FOUND-SW
           ELSE IF RESPONSE-CODE = DFHRESP(NOTFND)
               MOVE 'N' TO CUSTOMER-FOUND-SW
           ELSE
               PERFORM 9999-TERMINATE-PROGRAM.
      *
       1220-EDIT-LINE-ITEM.
      *
           MOVE ATTR-NO-HIGHLIGHT TO ORD-H-PCODE(ITEM-SUB)
                                     ORD-H-QTY(ITEM-SUB)
                                     ORD-H-NET(ITEM-SUB).

           MOVE 'N' TO PRODUCT-FOUND-SW.

           IF        ORD-L-PCODE(ITEM-SUB) > ZERO
                 AND ORD-D-PCODE(ITEM-SUB) NOT = SPACE
               MOVE 'Y' TO CA-PCODE-ENTERED-SW(ITEM-SUB)
           ELSE
               MOVE 'N' TO CA-PCODE-ENTERED-SW(ITEM-SUB).
           IF        ORD-L-QTY(ITEM-SUB) > ZERO
                 AND ORD-D-QTY-ALPHA(ITEM-SUB) NOT = SPACE
               MOVE 'Y' TO CA-QTY-ENTERED-SW(ITEM-SUB)
           ELSE
               MOVE 'N' TO CA-QTY-ENTERED-SW(ITEM-SUB).
           IF        ORD-L-NET(ITEM-SUB) > ZERO
                 AND ORD-D-NET-ALPHA(ITEM-SUB) NOT = SPACE
               MOVE 'Y' TO CA-NET-ENTERED-SW(ITEM-SUB)
           ELSE
               MOVE 'N' TO CA-NET-ENTERED-SW(ITEM-SUB).

           IF            CA-NET-ENTERED(ITEM-SUB)
                 AND NOT CA-PCODE-ENTERED(ITEM-SUB)
               MOVE ATTR-REVERSE TO ORD-H-PCODE(ITEM-SUB)
               MOVE -1 TO ORD-L-PCODE(ITEM-SUB)
               MOVE 'You cannot enter a net price without a product code
      -        '.' TO ORD-D-MESSAGE
               MOVE 'N' TO VALID-DATA-SW.

           IF CA-NET-ENTERED(ITEM-SUB)
               CALL 'NUMEDIT' USING ORD-D-NET-ALPHA(ITEM-SUB) 
           NET-NUMERIC VALID-NET-SW
               IF VALID-NET
                   MOVE NET-NUMERIC TO ORD-D-NET(ITEM-SUB)
               ELSE
                   MOVE ATTR-REVERSE TO ORD-H-NET(ITEM-SUB)
                   MOVE -1 TO ORD-L-NET(ITEM-SUB)
                   MOVE 'Net price must be numeric' TO ORD-D-MESSAGE
                   MOVE 'N' TO VALID-DATA-SW
                   MOVE 'N' TO VALID-QUANTITY-SW.

           IF            CA-QTY-ENTERED(ITEM-SUB)
                 AND NOT CA-PCODE-ENTERED(ITEM-SUB)
               MOVE ATTR-REVERSE TO ORD-H-PCODE(ITEM-SUB)
               MOVE -1 TO ORD-L-PCODE(ITEM-SUB)
               MOVE 'You cannot enter a quantity without a product code'
                   TO ORD-D-MESSAGE
               MOVE 'N' TO VALID-DATA-SW.

           IF CA-QTY-ENTERED(ITEM-SUB)
               CALL 'INTEDIT' USING ORD-D-QTY-ALPHA(ITEM-SUB) 
           QTY-NUMERIC VALID-QUANTITY-SW
               IF VALID-QUANTITY
                   IF QTY-NUMERIC > ZERO
                       MOVE QTY-NUMERIC TO ORD-D-QTY(ITEM-SUB)
                   ELSE
                       MOVE ATTR-REVERSE TO ORD-H-QTY(ITEM-SUB)
                       MOVE -1 TO ORD-L-QTY(ITEM-SUB)
                       MOVE 'Quantity must be greater than zero'
                           TO ORD-D-MESSAGE
                       MOVE 'N' TO VALID-DATA-SW
                       MOVE 'N' TO VALID-QUANTITY-SW
               ELSE
                   MOVE ATTR-REVERSE TO ORD-H-QTY(ITEM-SUB)
                   MOVE -1 TO ORD-L-QTY(ITEM-SUB)
                   MOVE 'Quantity must be numeric' TO ORD-D-MESSAGE
                   MOVE 'N' TO VALID-DATA-SW
                   MOVE 'N' TO VALID-QUANTITY-SW.

           IF            CA-PCODE-ENTERED(ITEM-SUB)
                 AND NOT CA-QTY-ENTERED(ITEM-SUB)
               MOVE ATTR-REVERSE TO ORD-H-QTY(ITEM-SUB)
               MOVE -1 TO ORD-L-QTY(ITEM-SUB)
               MOVE 'You must enter a quantity' TO ORD-D-MESSAGE
               MOVE 'N' TO VALID-DATA-SW.

           IF NOT CA-PCODE-ENTERED(ITEM-SUB)
               MOVE SPACE TO ORD-D-DESC(ITEM-SUB)
               MOVE ZERO  TO ORD-D-LIST(ITEM-SUB)
                             ORD-D-AMOUNT(ITEM-SUB)
           ELSE
      *    NW CHECK DIGIT
               PERFORM 1500-CHECK-PROD-CODE-FORMAT
               IF VALID-CHECK-DIGIT
                    ADD 1 TO LINE-ITEM-COUNT
                    PERFORM 1230-READ-PRODUCT-RECORD
               ELSE
      *             MOVE ATTR-REVERSE TO ORD-D-PCODE(ITEM-SUB)
      *             MOVE -1 TO ORD-L-NET(ITEM-SUB)
                    MOVE 'N' TO PRODUCT-FOUND-SW
                    MOVE 'N' TO VALID-DATA-SW
               END-IF

               IF PRODUCT-FOUND
                   MOVE PRM-PRODUCT-DESCRIPTION
                                       TO ORD-D-DESC(ITEM-SUB)
                   MOVE PRM-UNIT-PRICE TO ORD-D-LIST(ITEM-SUB)
                   IF NOT CA-NET-ENTERED(ITEM-SUB)
                       MOVE PRM-UNIT-PRICE TO ORD-D-NET(ITEM-SUB)
                                              NET-NUMERIC
                   END-IF
                   IF VALID-QUANTITY AND VALID-NET
                       MULTIPLY NET-NUMERIC BY QTY-NUMERIC
                           GIVING ORD-D-AMOUNT(ITEM-SUB)
                                  INV-AMOUNT(ITEM-SUB)
                           ON SIZE ERROR
                               MOVE ATTR-REVERSE TO ORD-H-QTY(ITEM-SUB)
                               MOVE -1 TO ORD-L-QTY(ITEM-SUB)
                               MOVE 'Line item amount is too large.'
                                   TO ORD-D-MESSAGE
                               MOVE 'N' TO VALID-DATA-SW
                               MOVE ZERO TO ORD-D-AMOUNT(ITEM-SUB)
                                            INV-AMOUNT(ITEM-SUB)
                       END-MULTIPLY
                       ADD INV-AMOUNT(ITEM-SUB) TO INV-INVOICE-TOTAL
                           ON SIZE ERROR
                               MOVE ATTR-REVERSE TO ORD-H-QTY(ITEM-SUB)
                               MOVE -1 TO ORD-L-QTY(ITEM-SUB)
                               MOVE 'Invoice total is too large.'
                                   TO ORD-D-MESSAGE
                               MOVE 'N' TO VALID-DATA-SW
                               MOVE ZERO TO INV-INVOICE-TOTAL
                       END-ADD
                   END-IF
               ELSE
                   IF VALID-CHECK-DIGIT
                        MOVE SPACE TO ORD-D-DESC(ITEM-SUB)
                        MOVE ZERO  TO ORD-D-LIST(ITEM-SUB)
                                 ORD-D-AMOUNT(ITEM-SUB)
                        MOVE ATTR-REVERSE TO ORD-H-PCODE(ITEM-SUB)
                        MOVE -1    TO ORD-L-PCODE(ITEM-SUB)
                        MOVE 'That product does not exist.'
                              TO ORD-D-MESSAGE
                        MOVE 'N'   TO VALID-DATA-SW
                   END-IF
               END-IF
           END-IF.
      *
       1230-READ-PRODUCT-RECORD.
      *
           EXEC CICS
               READ DATASET('PRODUCT')
                    INTO(PRODUCT-MASTER-RECORD)
                    RIDFLD(ORD-D-PCODE(ITEM-SUB))
                    RESP(RESPONSE-CODE)
           END-EXEC.
           IF RESPONSE-CODE = DFHRESP(NORMAL)
               MOVE 'Y' TO PRODUCT-FOUND-SW
           ELSE IF RESPONSE-CODE = DFHRESP(NOTFND)
               MOVE 'N' TO PRODUCT-FOUND-SW
           ELSE
               PERFORM 9999-TERMINATE-PROGRAM.
      *
       1300-FORMAT-INVOICE-RECORD.
      *
           EXEC CICS
               ADDRESS CWA(ADDRESS OF COMMON-WORK-AREA)
           END-EXEC
           MOVE CWA-DATE     TO INV-INVOICE-DATE.
           MOVE ORD-D-CUSTNO TO INV-CUSTOMER-NUMBER.
           MOVE ORD-D-PO     TO INV-PO-NUMBER.
           PERFORM VARYING ITEM-SUB FROM 1 BY 1
                     UNTIL ITEM-SUB > 10
               IF CA-PCODE-ENTERED(ITEM-SUB) THEN
                   MOVE ORD-D-PCODE(ITEM-SUB)
                             TO INV-PRODUCT-CODE(ITEM-SUB)
                   MOVE ORD-D-QTY(ITEM-SUB)
                             TO INV-QUANTITY(ITEM-SUB)
                   MOVE ORD-D-NET(ITEM-SUB)
                             TO INV-UNIT-PRICE(ITEM-SUB)
               END-IF
               IF NOT CA-PCODE-ENTERED(ITEM-SUB) THEN
                   MOVE SPACE TO INV-PRODUCT-CODE(ITEM-SUB)
                   MOVE ZERO  TO INV-QUANTITY(ITEM-SUB)
                                 INV-UNIT-PRICE(ITEM-SUB)
                                 INV-AMOUNT(ITEM-SUB)
               END-IF
           END-PERFORM.
           MOVE INVOICE-RECORD TO CA-INVOICE-RECORD.
      *
       1400-SEND-ORDER-MAP.
      *
           IF SET-ATTRIBUTES
               PERFORM 1410-SET-ATTRIBUTES
           ELSE IF RESET-ATTRIBUTES
               PERFORM 1420-RESET-ATTRIBUTES.

           IF SEND-ERASE
               EXEC CICS
                   SEND MAP('ORDMAP1')
                        MAPSET('ORDSET1')
                        FROM(ORDMAP1)
                        CURSOR
                        ERASE
               END-EXEC
           ELSE IF SEND-DATAONLY
               EXEC CICS
                   SEND MAP('ORDMAP1')
                        MAPSET('ORDSET1')
                        FROM(ORDMAP1)
                        CURSOR
                        DATAONLY
               END-EXEC
           ELSE IF SEND-DATAONLY-ALARM
               EXEC CICS
                   SEND MAP('ORDMAP1')
                        MAPSET('ORDSET1')
                        FROM(ORDMAP1)
                        CURSOR
                        DATAONLY
                        ALARM
               END-EXEC.
      *
       1410-SET-ATTRIBUTES.
      *
           MOVE ATTR-PROT TO ORD-A-CUSTNO.
           IF CA-PO-ENTERED
               MOVE ATTR-PROT TO ORD-A-PO
           ELSE
               MOVE ATTR-PROT-DARK TO ORD-A-PO.
           PERFORM VARYING ITEM-SUB FROM 1 BY 1
                   UNTIL ITEM-SUB > 10
               IF CA-PCODE-ENTERED(ITEM-SUB)
                   MOVE ATTR-PROT TO ORD-A-PCODE(ITEM-SUB)
               ELSE
                   MOVE ATTR-PROT-DARK TO ORD-A-PCODE(ITEM-SUB)
               END-IF
               IF CA-QTY-ENTERED(ITEM-SUB)
                   MOVE ATTR-PROT TO ORD-A-QTY(ITEM-SUB)
               ELSE
                   MOVE ATTR-PROT-DARK TO ORD-A-QTY(ITEM-SUB)
               END-IF
               IF        CA-NET-ENTERED(ITEM-SUB)
                      OR CA-PCODE-ENTERED(ITEM-SUB)
                   MOVE ATTR-PROT TO ORD-A-NET(ITEM-SUB)
               ELSE
                   MOVE ATTR-PROT-DARK TO ORD-A-NET(ITEM-SUB)
               END-IF
           END-PERFORM.
      *
       1420-RESET-ATTRIBUTES.
      *
           MOVE ATTR-UNPROT-MDT TO ORD-A-CUSTNO.
           IF CA-PO-ENTERED
               MOVE ATTR-UNPROT-MDT TO ORD-A-PO
           ELSE
               MOVE ATTR-UNPROT     TO ORD-A-PO.
           PERFORM VARYING ITEM-SUB FROM 1 BY 1
                   UNTIL ITEM-SUB > 10
               IF CA-PCODE-ENTERED(ITEM-SUB)
                   MOVE ATTR-UNPROT-MDT TO ORD-A-PCODE(ITEM-SUB)
               ELSE
                   MOVE ATTR-UNPROT     TO ORD-A-PCODE(ITEM-SUB)
               END-IF
               IF CA-QTY-ENTERED(ITEM-SUB)
                   MOVE ATTR-UNPROT-MDT TO ORD-A-QTY(ITEM-SUB)
               ELSE
                   MOVE ATTR-UNPROT     TO ORD-A-QTY(ITEM-SUB)
               END-IF
               IF CA-NET-ENTERED(ITEM-SUB)
                   MOVE ATTR-UNPROT-MDT TO ORD-A-NET(ITEM-SUB)
               ELSE
                   MOVE ATTR-UNPROT     TO ORD-A-NET(ITEM-SUB)
               END-IF
           END-PERFORM.
      *
       1500-CHECK-PROD-CODE-FORMAT.
      *
           MOVE ZEROES TO PROD-CD-FLDS.
           MOVE ORD-D-PCODE(ITEM-SUB)TO PROD-CD-FLDS
           PERFORM 1900-DIG-CHK.
      *
       1900-DIG-CHK.
           COMPUTE NMBRX2 ( 9 ) = NMBR ( 9 ) * 2.
           COMPUTE NMBRX2 ( 7 ) = NMBR ( 7 ) * 2.
           COMPUTE NMBRX2 ( 5 ) = NMBR ( 5 ) * 2.
           COMPUTE NMBRX2 ( 3 ) = NMBR ( 3 ) * 2.
           COMPUTE NMBRX2 ( 1 ) = NMBR ( 1 ) * 2.
           COMPUTE NMBRX2 ( 9 ) = DIGITA ( 9 ) + DIGITB ( 9 ).
           COMPUTE NMBRX2 ( 7 ) = DIGITA ( 7 ) + DIGITB ( 7 ).
           COMPUTE NMBRX2 ( 5 ) = DIGITA ( 5 ) + DIGITB ( 5 ).
           COMPUTE NMBRX2 ( 3 ) = DIGITA ( 3 ) + DIGITB ( 3 ).
           COMPUTE NMBRX2 ( 1 ) = DIGITA ( 1 ) + DIGITB ( 1 ).
           MOVE NMBRX2 ( 9 ) ( 2 : 1 ) TO CDNUM(9).
           MOVE NMBRX2 ( 7 ) ( 2 : 1 ) TO CDNUM(7).
           MOVE NMBRX2 ( 5 ) ( 2 : 1 ) TO CDNUM(5).
           MOVE NMBRX2 ( 3 ) ( 2 : 1 ) TO CDNUM(3).
           MOVE NMBRX2 ( 1 ) ( 2 : 1 ) TO CDNUM(1).
           MOVE PROD-CD-FLDS TO CDREPS.
           MOVE CDNUM(9) TO CDREP(9).
           MOVE CDNUM(7) TO CDREP(7).
           MOVE CDNUM(5) TO CDREP(5).
           MOVE CDNUM(3) TO CDREP(3).
           MOVE CDNUM(1) TO CDREP(1).
           COMPUTE REPCHECK-DIGIT =
               CDREP(1) + CDREP(2) + CDREP(3) + CDREP(4) + CDREP(5) +
               CDREP(6) + CDREP(7) + CDREP(8) + CDREP(9).
           COMPUTE CDACTUAL = (9 - REPCHECK-DIGIT).
           IF CDACTUAL = CHK-DIG
               MOVE 'Y' TO VALID-CHECK-DIGIT-SW
           ELSE
               MOVE 'N' TO VALID-CHECK-DIGIT-SW
               STRING 'Invalid Product CheckDigit, Try ', CDACTUAL
                   DELIMITED BY SIZE INTO ORD-D-MESSAGE.
      *
       2000-PROCESS-POST-ORDER.
      *
           MOVE CA-INVOICE-RECORD TO INVOICE-RECORD.
           EXEC CICS
               LINK PROGRAM('GETINV')
                    COMMAREA(INV-INVOICE-NUMBER)
           END-EXEC.
           PERFORM 2100-WRITE-INVOICE-RECORD.
           ADD 1 TO CA-TOTAL-ORDERS.
           MOVE 'Type order details.  Then press Enter.'
               TO ORD-D-INSTR.
           MOVE 'Order posted.' TO ORD-D-MESSAGE.
           MOVE 'F3=Exit   F12=Cancel' TO ORD-D-FKEY.
           MOVE -1 TO ORD-L-CUSTNO.
           SET SEND-ERASE TO TRUE.
           PERFORM 1400-SEND-ORDER-MAP.
      *
       2100-WRITE-INVOICE-RECORD.
      *
           EXEC CICS
               WRITE DATASET('INVOICE')
                     FROM(INVOICE-RECORD)
                     RIDFLD(INV-INVOICE-NUMBER)
           END-EXEC.
      *
       3000-SEND-TOTAL-LINE.
      *
           MOVE CA-TOTAL-ORDERS TO TL-TOTAL-ORDERS.
           EXEC CICS
               SEND TEXT FROM(TOTAL-LINE)
                         ERASE
                         FREEKB
           END-EXEC.
      *
       9999-TERMINATE-PROGRAM.
      *
           MOVE EIBRESP  TO ERR-RESP.
           MOVE EIBRESP2 TO ERR-RESP2.
           MOVE EIBTRNID TO ERR-TRNID.
           MOVE EIBRSRCE TO ERR-RSRCE.
           EXEC CICS
               XCTL PROGRAM('SYSERR')
                    COMMAREA(ERROR-PARAMETERS)
           END-EXEC.
